/*
 * Decompiled with CFR 0.152.
 */
package tw.com.prolific.driver.pl2303;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import android.widget.Toast;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class PL2303Driver {
    private boolean mReadPakcetChecker = false;
    public static final int BAUD0 = 0;
    public static final int BAUD75 = 75;
    public static final int BAUD150 = 150;
    public static final int BAUD300 = 300;
    public static final int BAUD600 = 600;
    public static final int BAUD1200 = 1200;
    public static final int BAUD1800 = 1800;
    public static final int BAUD2400 = 2400;
    public static final int BAUD4800 = 4800;
    public static final int BAUD9600 = 9600;
    public static final int BAUD14400 = 14400;
    public static final int BAUD19200 = 19200;
    public static final int BAUD38400 = 38400;
    public static final int BAUD57600 = 57600;
    public static final int BAUD115200 = 115200;
    public static final int BAUD230400 = 230400;
    public static final int BAUD460800 = 460800;
    public static final int BAUD614400 = 614400;
    public static final int BAUD921600 = 921600;
    public static final int BAUD1228800 = 1228800;
    public static final int BAUD2457600 = 2457600;
    public static final int BAUD3000000 = 3000000;
    public static final int BAUD6000000 = 6000000;
    private byte[] mPortSetting = new byte[7];
    private FlowControl mFlowCtrl = FlowControl.OFF;
    private int mControlLines = 0;
    private byte mStatusLines = 0;
    private int mPL2303Type = 0;
    static final int PL_SIO_SET_BITMODE_REQUEST = 11;
    static final int PL_SIO_READ_PINS_REQUEST = 12;
    private static final int SET_LINE_REQUEST_TYPE = 33;
    private static final int SET_LINE_REQUEST = 32;
    private static final int BREAK_REQUEST_TYPE = 33;
    private static final int BREAK_REQUEST = 35;
    private static final int BREAK_OFF = 0;
    private static final int GET_LINE_REQUEST_TYPE = 161;
    private static final int GET_LINE_REQUEST = 33;
    private static final int VENDOR_WRITE_REQUEST_TYPE = 64;
    private static final int VENDOR_WRITE_REQUEST = 1;
    private static final int VENDOR_READ_REQUEST_TYPE = 192;
    private static final int VENDOR_READ_REQUEST = 1;
    private static final int SET_CONTROL_REQUEST_TYPE = 33;
    private static final int SET_CONTROL_REQUEST = 34;
    private static final int CONTROL_DTR = 1;
    private static final int CONTROL_RTS = 2;
    public static final int PL_MAX_INTERFACE_NUM = 4;
    private static final String TAG = "PL2303HXDDriver";
    private final int mPacketSize = 64;
    private UsbManager mManager;
    private UsbDevice mDevice;
    private UsbDeviceConnection mDeviceConnection;
    private UsbInterface mInterface;
    private UsbEndpoint mPLEndpointBulkIN;
    private UsbEndpoint mPLEndpointBulkOUT;
    private UsbEndpoint mPLEndpointIntr;
    public static final int READBUF_SIZE = 4096;
    public static final int WRITEBUF_SIZE = 4096;
    private int mReadbufOffset;
    private int mReadbufRemain;
    byte[] mReadbuf = new byte[4096];
    private int RdTransferTimeOut = 5000;
    private int WrCTRLTransferTimeOut = 100;
    private ArrayBlockingQueue<Integer> iReadQueueArray = new ArrayBlockingQueue(4096, true);
    public static Object ReadQueueLock = new Object();
    private ReadDataThread mThread;
    private boolean iThreadAlive;
    private int incReadCount = 0;
    private int totalReadCount = 0;
    private boolean updateReadCount = false;
    private boolean isRS485Mode = false;
    private final String ACTION_USB_PERMISSION;
    private static final String[] Supported_VID_PID = new String[]{"067B:2303", "067B:2551"};
    private static final int iSupportedDevListCnt = Supported_VID_PID.length;
    Context mContext;
    private final int PL2303HXDTYPE = 4;
    private boolean bHasPermission;
    private boolean bIsPL2551BTYPE;
    private boolean bIsDisconnectShow;
    private final BroadcastReceiver mPermissionReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
            Log.i((String)PL2303Driver.TAG, (String)("Enter BroadcastReceiver" + action));
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                Log.i((String)PL2303Driver.TAG, (String)"lib:ACTION_USB_DEVICE_ATTACHED");
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                String deviceName = device.getDeviceName();
                if (PL2303Driver.this.mDevice != null && PL2303Driver.this.mDevice.equals((Object)deviceName)) {
                    Log.d((String)PL2303Driver.TAG, (String)"USB interface removed");
                    PL2303Driver.this.end();
                    if (PL2303Driver.this.bIsDisconnectShow) {
                        Toast.makeText((Context)PL2303Driver.this.mContext, (CharSequence)"disconnect", (int)0).show();
                    }
                }
                Log.i((String)PL2303Driver.TAG, (String)"ACTION_USB_DEVICE_DETACHED");
            } else if (action.equals(PL2303Driver.this.ACTION_USB_PERMISSION)) {
                1 var5_6 = this;
                synchronized (var5_6) {
                    if (!intent.getBooleanExtra("permission", false)) {
                        Log.i((String)PL2303Driver.TAG, (String)"Permission not granted :(");
                    } else {
                        if (device != null) {
                            int i = 0;
                            while (i < iSupportedDevListCnt) {
                                if (String.format("%04X:%04X", device.getVendorId(), device.getProductId()).equals(Supported_VID_PID[i])) {
                                    PL2303Driver.this.getInformation(device);
                                    break;
                                }
                                ++i;
                            }
                            Log.i((String)PL2303Driver.TAG, (String)(String.valueOf(String.format("%04X:%04X", device.getVendorId(), device.getProductId())) + " device not present!"));
                        }
                        Log.i((String)PL2303Driver.TAG, (String)"ACTION_USB_PERMISSION: Permission granted");
                    }
                }
            }
            Log.i((String)PL2303Driver.TAG, (String)"Leave BroadcastReceiver");
        }
    };
    public static UsbDevice sDevice = null;
    private Runnable mLoop = new Runnable(){

        public void run() {
            UsbDevice dev = sDevice;
            int i = 0;
            while (i < iSupportedDevListCnt) {
                if (String.format("%04X:%04X", dev.getVendorId(), dev.getProductId()).equals(Supported_VID_PID[i]) && !PL2303Driver.this.isConnected()) {
                    PL2303Driver.this.setUsbInterfaces(dev);
                    PL2303Driver.this.bHasPermission = true;
                    break;
                }
                ++i;
            }
        }
    };

    public PL2303Driver(UsbManager manager, Context mContext, String sAppName) {
        this.mManager = manager;
        this.mReadbufOffset = 0;
        this.mReadbufRemain = 0;
        this.bHasPermission = false;
        this.iThreadAlive = false;
        this.bIsPL2551BTYPE = false;
        this.mContext = mContext;
        this.bIsDisconnectShow = true;
        this.ACTION_USB_PERMISSION = sAppName;
    }

    private void setUsbInterfaces(UsbDevice device) {
        UsbDeviceConnection connection;
        int UARTintf = 0;
        if (this.mDeviceConnection != null) {
            if (this.mInterface != null) {
                this.mDeviceConnection.releaseInterface(this.mInterface);
                this.mInterface = null;
            }
            this.mDeviceConnection.close();
            this.mDevice = null;
            this.mDeviceConnection = null;
        }
        if (device == null) {
            return;
        }
        int index = 0;
        while (index < device.getInterfaceCount()) {
            UsbInterface intf = device.getInterface(index);
            if (255 == intf.getInterfaceClass() && intf.getInterfaceProtocol() == 0 && intf.getInterfaceSubclass() == 0) {
                UARTintf = index;
                break;
            }
            ++index;
        }
        Log.d((String)TAG, (String)("UARTintf index = " + UARTintf));
        UsbInterface intf = device.getInterface(UARTintf);
        Log.d((String)TAG, (String)("Found " + intf));
        if (device != null && intf != null && (connection = this.mManager.openDevice(device)) != null) {
            if (connection.claimInterface(intf, true)) {
                Log.d((String)TAG, (String)"claim interface succeeded");
                this.mDevice = device;
                this.mDeviceConnection = connection;
                this.mInterface = intf;
                if (this.getPLEndpoints(this.mInterface)) {
                    Log.i((String)TAG, (String)"setPLEndpoints succeeded");
                    return;
                }
                Log.i((String)TAG, (String)"not setPLEndpoints");
            } else {
                Log.d((String)TAG, (String)"claim interface failed");
                connection.close();
            }
        }
        Log.i((String)TAG, (String)"USB interface not found");
    }

    public boolean enumerate() {
        Log.i((String)TAG, (String)"enumerating");
        this.mManager = (UsbManager)this.mContext.getSystemService("usb");
        HashMap devlist = this.mManager.getDeviceList();
        Iterator deviter = devlist.values().iterator();
        PendingIntent pi = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0);
        while (deviter.hasNext()) {
            UsbDevice d = (UsbDevice)deviter.next();
            Log.i((String)TAG, (String)("Found device: " + String.format("%04X:%04X", d.getVendorId(), d.getProductId())));
            Log.i((String)TAG, (String)("iSupportedDevListCnt: " + iSupportedDevListCnt));
            int i = 0;
            while (i < iSupportedDevListCnt) {
                if (String.format("%04X:%04X", d.getVendorId(), d.getProductId()).equals(Supported_VID_PID[i])) {
                    Log.i((String)TAG, (String)("Device under: " + d.getDeviceName()));
                    IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
                    filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                    this.mContext.registerReceiver(this.mPermissionReceiver, filter);
                    if (!this.mManager.hasPermission(d)) {
                        this.mManager.requestPermission(d, pi);
                    } else {
                        this.getInformation(d);
                        if (String.format("%04X:%04X", d.getVendorId(), d.getProductId()).equals("067B:2551")) {
                            this.bIsPL2551BTYPE = true;
                        }
                        return true;
                    }
                }
                ++i;
            }
        }
        Log.i((String)TAG, (String)"no more devices found");
        return false;
    }

    private void getInformation(UsbDevice d) {
        sDevice = d;
        new Thread(this.mLoop).start();
    }

    private boolean init() {
        if (!this.bHasPermission) {
            Log.d((String)TAG, (String)"has not permission to access usb device");
            return false;
        }
        if (this.mDevice == null) {
            Log.i((String)TAG, (String)"mDevice == null");
            return false;
        }
        int res = this.initPL2303Chip(this.mDeviceConnection);
        if (res < 0) {
            Log.d((String)TAG, (String)("fail to init:initPL2303Chip" + res));
            return false;
        }
        if (this.mPL2303Type != 4) {
            Log.d((String)TAG, (String)"No PL2303HXD chip");
            return false;
        }
        this.mThread = new ReadDataThread();
        return true;
    }

    public boolean InitByDefualtValue() {
        if (!this.init()) {
            return false;
        }
        this.StartReadThread();
        return true;
    }

    public boolean InitByBaudRate(BaudRate R) {
        if (!this.init()) {
            return false;
        }
        int res = this.setup(R, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        if (res < 0) {
            Log.d((String)TAG, (String)("fail to InitByBaudRate" + (Object)((Object)R) + "res:" + res));
            return false;
        }
        this.StartReadThread();
        return true;
    }

    public boolean InitByPortSetting(BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) {
        if (!this.init()) {
            return false;
        }
        int res = this.setup(R, D, S, P, F);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to InitByPortSetting");
            return false;
        }
        this.StartReadThread();
        return true;
    }

    public void end() {
        if (this.mDevice != null) {
            this.StopReadThread();
            this.bIsPL2551BTYPE = false;
            this.mContext.unregisterReceiver(this.mPermissionReceiver);
            this.setUsbInterfaces(null);
        }
    }

    public boolean isConnected() {
        return this.mDevice != null && this.mPLEndpointBulkIN != null && this.mPLEndpointBulkOUT != null;
    }

    private boolean getPLEndpoints(UsbInterface usbIf) {
        if (usbIf == null) {
            return false;
        }
        int i = 0;
        while (i < usbIf.getEndpointCount()) {
            Log.i((String)TAG, (String)("EP: " + String.format("0x%02X", usbIf.getEndpoint(i).getAddress())));
            if (usbIf.getEndpoint(i).getType() == 2) {
                Log.i((String)TAG, (String)"Bulk Endpoint");
                if (usbIf.getEndpoint(i).getDirection() == 128) {
                    this.mPLEndpointBulkIN = usbIf.getEndpoint(i);
                } else {
                    this.mPLEndpointBulkOUT = usbIf.getEndpoint(i);
                }
            } else if (usbIf.getEndpoint(i).getType() == 3) {
                if (usbIf.getEndpoint(i).getDirection() == 128) {
                    this.mPLEndpointIntr = usbIf.getEndpoint(i);
                }
            } else {
                Log.i((String)TAG, (String)"Not any ep");
            }
            ++i;
        }
        return true;
    }

    private void isShowDisconnect(boolean bIsShow) {
        this.bIsDisconnectShow = bIsShow;
    }

    private void StartReadThread() {
        if (!this.iThreadAlive) {
            this.mThread.start();
            this.iThreadAlive = this.mThread.isAlive();
            Log.i((String)TAG, (String)("Start ReadThread:" + this.iThreadAlive));
        }
    }

    private void StopReadThread() {
        if (this.iThreadAlive && this.mThread != null) {
            this.mThread.StopReadDataThread();
            this.iThreadAlive = this.mThread.isAlive();
            Log.i((String)TAG, (String)("Stop ReadThread:" + this.iThreadAlive));
        }
    }

    private void SetThreadDelayTime(BaudRate R) {
        int[] nArray = new int[10];
        nArray[1] = 2;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 5;
        nArray[5] = 5;
        nArray[6] = 5;
        nArray[7] = 10;
        nArray[8] = 10;
        nArray[9] = 10;
        int[] DelayTimeLevel = nArray;
        int time = DelayTimeLevel[2];
        switch (R) {
            case B614400: 
            case B921600: 
            case B1228800: 
            case B2457600: 
            case B3000000: 
            case B6000000: {
                time = DelayTimeLevel[0];
                break;
            }
            case B115200: 
            case B230400: 
            case B460800: {
                time = DelayTimeLevel[1];
                break;
            }
            case B19200: 
            case B38400: 
            case B57600: {
                time = DelayTimeLevel[2];
                break;
            }
            case B4800: 
            case B9600: {
                time = DelayTimeLevel[3];
                break;
            }
            case B1800: 
            case B2400: {
                time = DelayTimeLevel[4];
                break;
            }
            case B1200: {
                time = DelayTimeLevel[5];
                break;
            }
            case B600: {
                time = DelayTimeLevel[6];
                break;
            }
            case B300: {
                time = DelayTimeLevel[7];
                break;
            }
            case B150: {
                time = DelayTimeLevel[8];
                break;
            }
            case B75: {
                time = DelayTimeLevel[9];
                break;
            }
            case B0: {
                time = 0;
                break;
            }
            default: {
                Log.d((String)TAG, (String)"Baudrate not supported");
                return;
            }
        }
        Log.i((String)TAG, (String)("baudrate:" + (Object)((Object)R) + "; time:" + time));
        if (this.mThread != null) {
            this.mThread.SetDelayTimeMS(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf) {
        int ret;
        int buflen = buf.length;
        if (buflen == 0) {
            Log.i((String)TAG, (String)"buf length :no data ");
            return 0;
        }
        if (buflen > 4096) {
            Log.i((String)TAG, (String)"buf length over READBUF_SIZE, re-assign buf size");
            buf = new byte[4096];
        }
        Object object = ReadQueueLock;
        synchronized (object) {
            int queuelen = this.iReadQueueArray.size();
            if (queuelen > 0) {
                Log.i((String)TAG, (String)("QueueCount=" + queuelen));
                ret = buflen >= queuelen ? queuelen : buflen;
                int i = 0;
                while (i < ret) {
                    Integer mdata = this.iReadQueueArray.poll();
                    if (mdata == null) {
                        Log.i((String)TAG, (String)("this queue is empty" + ret));
                        break;
                    }
                    buf[i] = (byte)(mdata & 0xFF);
                    ++i;
                }
            } else {
                ret = 0;
            }
        }
        return ret;
    }

    private int ReadFromHW(byte[] buf, int rlength) {
        int len;
        if (buf.length == 0 || rlength == 0) {
            Log.i((String)TAG, (String)"buf length :no data ");
            return 0;
        }
        if (this.mReadbufRemain > 0 && rlength <= this.mReadbufRemain) {
            if (!this.mReadPakcetChecker) {
                System.arraycopy(this.mReadbuf, this.mReadbufOffset, buf, 0, rlength);
            } else {
                int i = 0;
                while (i < rlength) {
                    buf[i] = this.mReadbuf[this.mReadbufOffset++];
                    ++this.incReadCount;
                    while ((this.incReadCount - 1) % 10 != Byte.valueOf(buf[i]) - 48) {
                        Log.d((String)TAG, (String)("!!! Lost Data !!! count : " + (this.incReadCount - 1) + ", data : " + buf[i]));
                        ++this.incReadCount;
                    }
                    ++i;
                }
                Log.d((String)TAG, (String)("read buf length 1 : " + Integer.toString(rlength)));
                this.totalReadCount += rlength;
                this.updateReadCount = true;
            }
            this.mReadbufRemain -= rlength;
            return rlength;
        }
        int ofst = 0;
        int needlen = rlength;
        if (this.mReadbufRemain > 0) {
            needlen -= this.mReadbufRemain;
            System.arraycopy(this.mReadbuf, this.mReadbufOffset, buf, ofst, this.mReadbufRemain);
        }
        if ((len = this.mDeviceConnection.bulkTransfer(this.mPLEndpointBulkIN, this.mReadbuf, this.mReadbuf.length, this.RdTransferTimeOut)) < 0) {
            return len;
        }
        if (len == 0) {
            return 0;
        }
        Log.i((String)TAG, (String)("Read Length:" + len));
        int blocks = len / 64;
        int remain = len % 64;
        if (remain > 0) {
            ++blocks;
        }
        this.mReadbufRemain = len;
        int rbufindex = 0;
        int block = 0;
        while (block < blocks) {
            int blockofst = block * 64;
            int i = 0;
            while (i < 64) {
                this.mReadbuf[rbufindex++] = this.mReadbuf[blockofst + i];
                ++i;
            }
            ++block;
        }
        this.mReadbufOffset = 0;
        while (this.mReadbufRemain > 0 && needlen > 0) {
            buf[ofst++] = this.mReadbuf[this.mReadbufOffset++];
            if (this.mReadPakcetChecker) {
                ++this.incReadCount;
                while ((this.incReadCount - 1) % 10 != Byte.valueOf(buf[ofst - 1]) - 48) {
                    Log.d((String)TAG, (String)("!!! Lost Data !!! count : " + (this.incReadCount - 1) + ", data : " + Byte.toString(buf[ofst - 1])));
                    ++this.incReadCount;
                }
            }
            --this.mReadbufRemain;
            --needlen;
        }
        if (this.mReadPakcetChecker) {
            if (ofst > 0) {
                Log.d((String)TAG, (String)("read buf length 2 : " + Integer.toString(ofst)));
                this.totalReadCount += ofst;
                this.updateReadCount = true;
            }
            if (this.updateReadCount) {
                Log.d((String)TAG, (String)("Total of Read Count : " + this.totalReadCount));
                Log.d((String)TAG, (String)("Increment Read Count : " + this.incReadCount));
                this.updateReadCount = false;
            }
        }
        return ofst;
    }

    public int write(byte[] buf) {
        return this.write(buf, buf.length);
    }

    public int write(byte[] buf, int wlength) {
        int offset = 0;
        byte[] write_buf = new byte[4096];
        while (offset < wlength) {
            int write_size = 4096;
            if (offset + write_size > wlength) {
                write_size = wlength - offset;
            }
            System.arraycopy(buf, offset, write_buf, 0, write_size);
            Log.i((String)TAG, (String)("offset:" + offset + ",write_size:" + write_size + ",wlength:" + wlength));
            int actual_length = this.mDeviceConnection.bulkTransfer(this.mPLEndpointBulkOUT, write_buf, write_size, this.WrCTRLTransferTimeOut);
            if (actual_length < 0) {
                Log.i((String)TAG, (String)("fail to write:" + actual_length));
                return -1;
            }
            offset += actual_length;
        }
        Log.i((String)TAG, (String)("Write Length:" + offset));
        return offset;
    }

    public int setup(BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) {
        int res = 0;
        if (this.mDeviceConnection == null) {
            Log.d((String)TAG, (String)"Connection closed");
            return -1;
        }
        res = this.mDeviceConnection.controlTransfer(161, 33, 0, 0, this.mPortSetting, 7, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to setup:get line request");
            return res;
        }
        Log.d((String)TAG, (String)("Current serial configuration:" + this.mPortSetting[0] + "," + this.mPortSetting[1] + "," + this.mPortSetting[2] + "," + this.mPortSetting[3] + "," + this.mPortSetting[4] + "," + this.mPortSetting[5] + "," + this.mPortSetting[6]));
        int baud = 0;
        switch (R) {
            case B0: {
                baud = 0;
                break;
            }
            case B75: {
                baud = 75;
                break;
            }
            case B150: {
                baud = 150;
                break;
            }
            case B300: {
                baud = 300;
                break;
            }
            case B600: {
                baud = 600;
                break;
            }
            case B1200: {
                baud = 1200;
                break;
            }
            case B1800: {
                baud = 1800;
                break;
            }
            case B2400: {
                baud = 2400;
                break;
            }
            case B4800: {
                baud = 4800;
                break;
            }
            case B9600: {
                baud = 9600;
                break;
            }
            case B19200: {
                baud = 19200;
                break;
            }
            case B38400: {
                baud = 38400;
                break;
            }
            case B57600: {
                baud = 57600;
                break;
            }
            case B115200: {
                baud = 115200;
                break;
            }
            case B230400: {
                baud = 230400;
                break;
            }
            case B460800: {
                baud = 460800;
                break;
            }
            case B614400: {
                baud = 614400;
                break;
            }
            case B921600: {
                baud = 921600;
                break;
            }
            case B1228800: {
                baud = 1228800;
                break;
            }
            case B2457600: {
                baud = 2457600;
                break;
            }
            case B3000000: {
                baud = 3000000;
                break;
            }
            case B6000000: {
                baud = 6000000;
                break;
            }
            default: {
                Log.d((String)TAG, (String)"Baudrate not supported");
                return -2;
            }
        }
        if (baud > 1228800 && this.mPL2303Type == 0) {
            Log.d((String)TAG, (String)"Baudrate not supported: Only PL2303HX supports the higher baudrates");
            return -2;
        }
        if (this.mThread != null) {
            this.SetThreadDelayTime(R);
            Log.d((String)TAG, (String)("SetThreadDelayTime:" + baud));
        }
        Log.d((String)TAG, (String)("setup:" + baud));
        this.mPortSetting[0] = (byte)(baud & 0xFF);
        this.mPortSetting[1] = (byte)(baud >> 8 & 0xFF);
        this.mPortSetting[2] = (byte)(baud >> 16 & 0xFF);
        this.mPortSetting[3] = (byte)(baud >> 24 & 0xFF);
        switch (S) {
            case S1: {
                this.mPortSetting[4] = 0;
                break;
            }
            case S2: {
                this.mPortSetting[4] = 2;
                break;
            }
            default: {
                Log.d((String)TAG, (String)"Stopbit setting not supported");
                return -3;
            }
        }
        switch (P) {
            case NONE: {
                this.mPortSetting[5] = 0;
                break;
            }
            case ODD: {
                this.mPortSetting[5] = 1;
                break;
            }
            case EVEN: {
                this.mPortSetting[5] = 2;
                break;
            }
            default: {
                Log.d((String)TAG, (String)"Parity setting not supported");
                return -4;
            }
        }
        switch (D) {
            case D5: {
                this.mPortSetting[6] = 5;
                break;
            }
            case D6: {
                this.mPortSetting[6] = 6;
                break;
            }
            case D7: {
                this.mPortSetting[6] = 7;
                break;
            }
            case D8: {
                this.mPortSetting[6] = 8;
                break;
            }
            default: {
                Log.d((String)TAG, (String)"Databit setting not supported");
                return -5;
            }
        }
        res = this.mDeviceConnection.controlTransfer(33, 32, 0, 0, this.mPortSetting, 7, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.e((String)TAG, (String)"Error in setting serial configuration");
            return res;
        }
        Log.d((String)TAG, (String)("New serial configuration:" + this.mPortSetting[0] + "," + this.mPortSetting[1] + "," + this.mPortSetting[2] + "," + this.mPortSetting[3] + "," + this.mPortSetting[4] + "," + this.mPortSetting[5] + "," + this.mPortSetting[6]));
        res = this.mDeviceConnection.controlTransfer(33, 35, 0, 0, null, 0, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to setup:break off");
            return res;
        }
        switch (F) {
            case OFF: {
                res = this.mDeviceConnection.controlTransfer(64, 1, 0, 0, null, 0, this.WrCTRLTransferTimeOut);
                if (res < 0) {
                    Log.d((String)TAG, (String)"fail to setup:write request");
                    return res;
                }
                res = this.setRTS(false);
                if (res < 0) {
                    Log.d((String)TAG, (String)"fail to setRTS");
                    return res;
                }
                res = this.setDTR(false);
                if (res < 0) {
                    Log.d((String)TAG, (String)"fail to setDTR");
                    return res;
                }
                this.mFlowCtrl = F;
                Log.d((String)TAG, (String)"FlowControl disabled");
                break;
            }
            case RTSCTS: {
                res = this.mPL2303Type == 1 ? this.mDeviceConnection.controlTransfer(64, 1, 0, 97, null, 0, this.WrCTRLTransferTimeOut) : this.mDeviceConnection.controlTransfer(64, 1, 0, 65, null, 0, this.WrCTRLTransferTimeOut);
                if (res < 0) {
                    Log.d((String)TAG, (String)"fail to setup");
                    return res;
                }
                res = this.setDTR(true);
                if (res < 0) {
                    Log.d((String)TAG, (String)"fail to setDTR");
                    return res;
                }
                res = this.setRTS(true);
                if (res < 0) {
                    Log.d((String)TAG, (String)"fail to setRTS");
                    return res;
                }
                this.mFlowCtrl = F;
                Log.d((String)TAG, (String)"RTS/CTS FlowControl enabled");
            }
        }
        return 0;
    }

    public int setDTR(boolean state) {
        int res;
        if (state && (this.mControlLines & 1) != 1) {
            ++this.mControlLines;
        }
        if (!state && (this.mControlLines & 1) == 1) {
            --this.mControlLines;
        }
        if ((res = this.mDeviceConnection.controlTransfer(33, 34, this.mControlLines, 0, null, 0, this.WrCTRLTransferTimeOut)) < 0) {
            Log.d((String)TAG, (String)"fail to setup");
            return res;
        }
        Log.d((String)TAG, (String)("DTR set to " + state));
        return 0;
    }

    public int setRTS(boolean state) {
        int res;
        if (state && (this.mControlLines & 2) != 2) {
            this.mControlLines += 2;
        }
        if (!state && (this.mControlLines & 2) == 2) {
            this.mControlLines -= 2;
        }
        if ((res = this.mDeviceConnection.controlTransfer(33, 34, this.mControlLines, 0, null, 0, this.WrCTRLTransferTimeOut)) < 0) {
            Log.d((String)TAG, (String)"fail to setup");
            return res;
        }
        Log.d((String)TAG, (String)("RTS set to " + state));
        return 0;
    }

    private int initPL2303Chip(UsbDeviceConnection conn) {
        int res = 0;
        if (this.bIsPL2551BTYPE) {
            this.mPL2303Type = 4;
        } else {
            if (conn.getRawDescriptors()[13] == 4) {
                this.mPL2303Type = 4;
            }
            if ((res = this.checkPL2303ChipType(conn)) < 0) {
                return res;
            }
            res = this.checkRS485Mode(conn);
            if (res < 0) {
                return res;
            }
        }
        if (this.mPL2303Type != 4) {
            return -1;
        }
        byte[] buffer = new byte[1];
        res = conn.controlTransfer(192, 1, 33924, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip");
            return res;
        }
        res = conn.controlTransfer(64, 1, 1028, 0, null, 0, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip");
            return res;
        }
        res = conn.controlTransfer(192, 1, 33924, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip");
            return res;
        }
        res = conn.controlTransfer(192, 1, 33667, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip");
            return res;
        }
        res = conn.controlTransfer(192, 1, 33924, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip");
            return res;
        }
        res = conn.controlTransfer(64, 1, 1028, 1, null, 0, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip");
            return res;
        }
        res = conn.controlTransfer(192, 1, 33924, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip");
            return res;
        }
        res = conn.controlTransfer(192, 1, 33667, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip");
            return res;
        }
        if (this.isRS485Mode) {
            res = conn.controlTransfer(64, 1, 0, 49, null, 0, this.WrCTRLTransferTimeOut);
            if (res < 0) {
                Log.d((String)TAG, (String)"fail to initPL2303Chip");
                return res;
            }
            res = conn.controlTransfer(64, 1, 1, 8, null, 0, this.WrCTRLTransferTimeOut);
            if (res < 0) {
                Log.d((String)TAG, (String)"fail to initPL2303Chip");
                return res;
            }
            Log.d((String)TAG, (String)"RS485 Mode detected");
        } else {
            res = conn.controlTransfer(64, 1, 0, 1, null, 0, this.WrCTRLTransferTimeOut);
            if (res < 0) {
                Log.d((String)TAG, (String)"fail to initPL2303Chip");
                return res;
            }
            res = conn.controlTransfer(64, 1, 1, 0, null, 0, this.WrCTRLTransferTimeOut);
            if (res < 0) {
                Log.d((String)TAG, (String)"fail to initPL2303Chip");
                return res;
            }
            Log.d((String)TAG, (String)"RS232 Mode detected");
        }
        res = conn.controlTransfer(64, 1, 2, 68, null, 0, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip");
            return res;
        }
        res = this.setup(BaudRate.B9600, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to initPL2303Chip: setup");
            return res;
        }
        return 0;
    }

    private int checkPL2303ChipType(UsbDeviceConnection conn) {
        int res = 0;
        byte[] buffer = new byte[1];
        res = conn.controlTransfer(64, 1, 1, 255, null, 0, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to checkPL2303ChipType");
            return res;
        }
        res = conn.controlTransfer(192, 1, 33153, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to checkPL2303ChipType");
            return res;
        }
        return 0;
    }

    private int checkRS485Mode(UsbDeviceConnection conn) {
        int readAddress = 9;
        int res = 0;
        byte[] buffer = new byte[1];
        res = conn.controlTransfer(192, 1, 33924, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to CheckRS485Mode:read");
            return res;
        }
        res = conn.controlTransfer(64, 1, 1028, readAddress, null, 0, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to CheckRS485Mode:write");
            return res;
        }
        res = conn.controlTransfer(192, 1, 33924, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to CheckRS485Mode:read");
            return res;
        }
        res = conn.controlTransfer(192, 1, 33667, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            Log.d((String)TAG, (String)"fail to CheckRS485Mode:read");
            return res;
        }
        if (buffer[0] == 8) {
            this.isRS485Mode = true;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaudRate {
        B0,
        B75,
        B150,
        B300,
        B600,
        B1200,
        B1800,
        B2400,
        B4800,
        B9600,
        B19200,
        B38400,
        B57600,
        B115200,
        B230400,
        B460800,
        B614400,
        B921600,
        B1228800,
        B2457600,
        B3000000,
        B6000000;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataBits {
        D5,
        D6,
        D7,
        D8;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlowControl {
        OFF,
        RTSCTS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parity {
        NONE,
        ODD,
        EVEN;

    }

    class ReadDataThread
    extends Thread {
        private int iReadCnt;
        private int iQueueCount;
        private boolean ret = true;
        private boolean bStop = false;
        private AtomicInteger iDelayTimeMS = new AtomicInteger(500);

        ReadDataThread() {
        }

        public void ReadDataThead() {
            this.iQueueCount = 0;
            this.iReadCnt = 0;
            PL2303Driver.this.iReadQueueArray.clear();
        }

        public void ReadDataThead(int mTimeMS) {
            this.ReadDataThead();
            this.SetDelayTimeMS(mTimeMS);
        }

        public void SetDelayTimeMS(int mTimeMS) {
            this.iDelayTimeMS.set(mTimeMS);
        }

        public void StopReadDataThread() {
            this.bStop = true;
            while (this.isAlive()) {
            }
            PL2303Driver.this.iReadQueueArray.clear();
        }

        private void DelayTime(int dwTimeMS) {
            long CheckTime;
            if (dwTimeMS == 0) {
                return;
            }
            long StartTime = System.currentTimeMillis();
            do {
                CheckTime = System.currentTimeMillis();
                Thread.yield();
            } while (CheckTime - StartTime <= (long)dwTimeMS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] rbuf = new byte[4096];
                while (!this.bStop) {
                    this.iReadCnt = PL2303Driver.this.ReadFromHW(rbuf, rbuf.length);
                    if (this.iReadCnt > 0) {
                        Object object = ReadQueueLock;
                        synchronized (object) {
                            this.iQueueCount = PL2303Driver.this.iReadQueueArray.size();
                            if (4096 == this.iQueueCount) {
                                Log.i((String)PL2303Driver.TAG, (String)"Queue is full");
                            } else {
                                int i = 0;
                                while (i < this.iReadCnt && this.iQueueCount < 4096) {
                                    this.ret = PL2303Driver.this.iReadQueueArray.offer(Integer.valueOf(rbuf[i]));
                                    if (!this.ret) {
                                        Log.i((String)PL2303Driver.TAG, (String)"Queue is full");
                                        break;
                                    }
                                    this.iQueueCount = PL2303Driver.this.iReadQueueArray.size();
                                    ++i;
                                }
                            }
                        }
                    }
                    int time = this.iDelayTimeMS.get();
                    this.DelayTime(time);
                }
            }
            catch (Exception e) {
                Log.i((String)PL2303Driver.TAG, (String)("error: " + e.getMessage()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StopBits {
        S1,
        S2;

    }
}

